function Figure1H()
% Running this script produces the plots shown in Figure 1H

load('5C4IgG.mat'); A = mAb; C = C3; F = F;
[N,x] = hist3([log10(A)',log10(C)'],'Ctrs',{0:.2:7 0:.2:7});
N = N./max(max(N));
  
v0 = [0.2:0.1:1];
figure;
[M,junk] = contour(x{1},x{2},N',v0); close
lowest = 1;
while lowest == 1;
  lev = M(1,1);
  v = M(2,1); xy = M(:,2:(1+v))';
  in = inpolygon(log10(A),log10(C),xy(:,1),xy(:,2));
  A(in) = []; C(in) = [];
  M(:,1:(1+v)) = [];
  next_lev = M(1,1);
  if(next_lev == lev); lowest = 1;
  else lowest = 0; end
end

figure; hold on;
contour(x{1},x{2},N',v0,'LineWidth',1.5,'Color',[0 0.2 0.8]); 
view(2); xlim([1 6]); ylim([1 6]); axis square;
clear;

load('5C4IgM.mat'); A = mAb; C = C3; F = F;
[N,x] = hist3([log10(A)',log10(C)'],'Ctrs',{0:.2:7 0:.2:7});
N = N./max(max(N));
  
v0 = [0.2:0.1:1];
figure;
[M,junk] = contour(x{1},x{2},N',v0); close
lowest = 1;
while lowest == 1;
  lev = M(1,1);
  v = M(2,1); xy = M(:,2:(1+v))';
  in = inpolygon(log10(A),log10(C),xy(:,1),xy(:,2));
  A(in) = []; C(in) = [];
  M(:,1:(1+v)) = [];
  next_lev = M(1,1);
  if(next_lev == lev); lowest = 1;
  else lowest = 0; end
end

contour(x{1},x{2},N',v0,'LineWidth',1.5,'Color',[0.8 0.2 0]); 
title('5C4 IgG / IgM'); ylabel('log10[C3 intensity per particle]');
xlabel('log10[mAb intensity per particle]');
view(2); xlim([1 6]); ylim([1 6]); axis square;
  
 


  